using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywoanie programu: Program plik");
      return;
    }
    String plik = args[0];

    BinaryReader br;
    try
    {
      br = new BinaryReader(new FileStream(plik, FileMode.Open));
    }
    catch(Exception)
    {
      Console.WriteLine("Otwarcie pliku {0} nie powiodo si.", plik);
      return;
    }

    try
    {
      Console.WriteLine("Wartoci odczytane z pliku: ", plik);
      int ile = br.ReadInt32();
      for(int i = 0; i < ile; i++)
      {
        int wartosc = br.ReadInt32();
        Console.Write(wartosc + " ");
      }
      br.Close();
    }
    catch(Exception)
    {
      Console.WriteLine("Wystpi bd w trakcie odczytu danych.");
      return;
    }
  }
}
